% Script3DVolumeOfValidIC


clear

TimeStart = datevec(now); % Its is a 6x1 vector containing:  [Year Month Day Hour Minute Second]

eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_3D_VICR']);
copyfile('Script3DVolumeOfValidIC.m',['', DATESTR(datenum(TimeStart),30), '_Script3DVolumeOfValidIC.m']);
open Script3DVolumeOfValidIC.m

cd ..
cd 'InitialCondiction'
eval(['mkdir ', DATESTR(datenum(TimeStart),30), '_InitialCondiction']);
run Sim_IC_All
cd ..
cd '5 3D Valid IC Region'


figure(5)
Begining = min(InitionConditionNotProblems(:,3));
End = max(InitionConditionNotProblems(:,3));
Step = round((End - Begining)/13);
% There are 7 colors: b g r c m y k
% We use 13 colors, with yelow in the center: b g r c m k y b g r c m k 
color='b.g.r.c.m.k.y.b.g.r.c.m.k.';
c=1;

F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < Begining + Step);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < Begining + Step);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < Begining + Step);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < Begining + Step);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < Begining + Step);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < Begining + Step);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < 11000);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < 11000);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < 11000);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < 11000);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < 11000);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < 11000);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

c = c + 2; Begining = Begining + Step;
F = find(InitionConditionNotProblems(:,3) > Begining & InitionConditionNotProblems(:,3) < 11000);
plot3(InitionConditionNotProblems(F,1),InitionConditionNotProblems(F,2),InitionConditionNotProblems(F,3),color(c:c+1))
grid on; hold on;

open sprottbxilinx.mdl

startime = 0;
stoptime = 900; % We do not need to run the simulink simulation for a very long time, because during the encryption algorithm it will not run so long...
stepsize = 0.01;

binpoint = 46;
latenciamultiplier = 5;

xzero = 0.001;
yzero = 0.001;
zzero = 0.001;

SimStart = now;            
sim('sprottbxilinx.mdl');

plot3(xoutx,youtx,zoutx,'k')
grid on;
hold on;
plot3(xoutx,youtx,zoutx,'k.')

title(['3D Valid Initial Condition Region, Date: ', DATESTR(TimeStart,1), ', Time: ', DATESTR(TimeStart,15), '']);
xlabel(['Variable xoutx']);
ylabel(['Variable youtx']);
zlabel(['Variable zoutx from Lorenz equations']);
eval(['cd ', DATESTR(datenum(TimeStart),30), '_3D_VICR']);
filename = ([DATESTR(datevec(SimStart),30), '_3D_VICR.fig']);
saveas(5, filename, 'fig');
filename = ([DATESTR(datevec(SimStart),30), '_3D_VICR.jpg']);
saveas(5, filename, 'jpg');
close(5)
cd ..

% Now it plays a sound that indicates the end of the simulation
[SimEnd,FqSp,NBits]=wavread('EndOfSimulation.wav');
soundsc(SimEnd,FqSp)
fprintf('\n')
% Now it saves and prints the End of Simulation Time
EndOfSimulation = datestr(now);
fprintf('The simulations Starts on %s\n', datestr(TimeStart));
fprintf('The simulations Ends on %s\n', datestr(EndOfSimulation));
fprintf('\n')

